const toggleMenu = document.getElementById("toggleMenu");

if(toggleMenu){
  toggleMenu.addEventListener("click", function () {
  const nav = document.getElementById("menu");
  nav.classList.toggle("active");
  });
}

const topBtn = document.getElementById("topBtn");

window.onscroll = function () {
  if (document.documentElement.scrollTop > 300) {
    topBtn.style.display = "block";
  } else {
    topBtn.style.display = "none";
  }
};

if(topBtn){
  topBtn.addEventListener("click", function () {
    window.scrollTo({ top: 0, behavior: "smooth" });
  });
}

const toggleAllBtn = document.getElementById("toggleAll");

if (toggleAllBtn) {
  toggleAllBtn.addEventListener("click", function () {
    const detailsElements = document.querySelectorAll("details");
    const allExpanded = [...detailsElements].every((details) => details.open);

    detailsElements.forEach((details) => {
      details.open = !allExpanded;  // Expande se pelo menos um estiver fechado, colapsa se todos estiverem abertos
    });

    this.textContent = allExpanded
      ? "Expandir todas as descrições"
      : "Colapsar todas as descrições";
  });
}

function ytFrameJumpToTime(id, segundos) {
  var iframe = document.getElementById('YTPlayer-' + id);

  if (iframe) {
    var novaUrl = 'https://www.youtube.com/embed/' + id + '?start=' + segundos + '&autoplay=1';
    iframe.src = novaUrl;
  }
}

const jumpBtns = document.querySelectorAll('.btn-jump');
jumpBtns.forEach(btn => {
  btn.addEventListener("click", function(event){
    event.preventDefault();
    const videoId = this.getAttribute('data-video-id');
    const videoTime = this.getAttribute('data-video-time');
    ytFrameJumpToTime(videoId, videoTime);
  });
});
